﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Promotion
{
    public partial class EditPromotions : System.Web.UI.Page
    {
        private Entities.Promotion currentPromo;
        private PromotionDetails currPromoCode;
        private Products currentProduct;
        private static DataTable productTable, brandTable, sizeTable;
        private static List<Products> productList;
        private static List<PromotionDetails> promoOptions;

        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                promoOptions = new List<PromotionDetails>();
                FillListItems(true);
                BindPromotionDetails();
                if (Request.QueryString["UniqueID"] != null)
                {
                    hdPromotionID.Value = Request.QueryString["UniqueID"].ToString();
                    ShowPromoCodeDetails();
                }
            }
        }

        private void FillListItems(bool loadEvent)
        {
            List<Entities.Products> ProductList = ProductsBL.GetList(Guid.Empty, string.Empty);
            if (ProductList != null && ProductList.Count > 0)
            {
                ProductList = ProductList.Where(a => a.IsActive).ToList<Entities.Products>();
            }

            List<Entities.ProductMeasurement> SizeList = ProductMeasurementBL.GetList(Guid.Empty, string.Empty);
            if (SizeList != null && SizeList.Count > 0)
            {
                SizeList = SizeList.Where(a => a.IsActive).ToList<Entities.ProductMeasurement>();
            }

            List<Entities.ProductCategory> CategoryList = ProductCategoryBL.GetList(Guid.Empty, string.Empty);
            if (CategoryList != null && CategoryList.Count > 0)
            {
                CategoryList = CategoryList.Where(a => a.IsActive).ToList<Entities.ProductCategory>();
            }

            List<Entities.ProductBrand> BrandList = ProductBrandBL.GetList(Guid.Empty, string.Empty);
            if (BrandList != null && BrandList.Count > 0)
            {
                BrandList = BrandList.Where(a => a.IsActive).ToList<Entities.ProductBrand>();
            }

            WebUtilities.FillDropDownList<Entities.ProductCategory>(ddlCategory, CategoryList, "UniqueID", "CategoryName");
            WebUtilities.FillDropDownList<Entities.ProductBrand>(ddlBrand, BrandList, "UniqueID", "BrandName");
            WebUtilities.FillDropDownList<Entities.ProductMeasurement>(ddlSize, SizeList, "UniqueID", "MeasurementName");
            WebUtilities.FillDropDownList<Entities.Products>(ddlProduct, ProductList, "UniqueID", "ProductName");
            if (loadEvent)
            {
                productTable = ProductsBL.GetDataTable(Guid.Empty, string.Empty);
                brandTable = ProductBrandBL.GetDataTable(Guid.Empty, string.Empty);
                sizeTable = ProductMeasurementBL.GetDataTable(Guid.Empty, string.Empty);
                productList = ProductsBL.GetList(Guid.Empty, string.Empty);
            }
        }

        private void ShowPromoCodeDetails()
        {
            currentPromo = PromotionBL.GetItem(Guid.Parse(hdPromotionID.Value.Trim()), DateTime.MinValue, DateTime.MinValue, string.Empty);
            if (currentPromo != null)
            {
                hdPromotionID.Value = currentPromo.UniqueID.ToString();
                //ddlPromoType.SelectedIndex = ddlPromoType.Items.IndexOf(ddlPromoType.Items.FindByValue(currPromoCode.PromoType));
                txtPromotionName.Text = currentPromo.PromotionName;
                txtStartDate.Text = (currentPromo.StartDate != DateTime.MinValue ? currentPromo.StartDate.ToString("dd/MM/yyyy") : string.Empty);
                txtEndDate.Text = (currentPromo.EndDate != DateTime.MinValue ? currentPromo.EndDate.ToString("dd/MM/yyyy") : string.Empty);
                txtMaxUsage.Text = currentPromo.AvailableUsage.ToString();
                txtPriceRangeFrom.Text = (currentPromo.OrderTotalFrom > 0 ? currentPromo.OrderTotalFrom.ToString("0.00") : string.Empty);
                txtPriceRangeTo.Text = (currentPromo.OrderTotalTo > 0 ? currentPromo.OrderTotalTo.ToString("0.00") : string.Empty);
                chkUseFromPrice.Checked = currentPromo.UseFromPrice;
                chkIsActive.Checked = currentPromo.IsActive;

                promoOptions = currentPromo.PromotionDetailsList.Where(x => x.IsActive == true).ToList();
                BindPromotionDetails();
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (ValidatePageValue())
            {
                currentPromo = new Entities.Promotion();
                if (hdPromotionID.Value.Trim().Length == 0)
                    currentPromo.Mode = GlobalConfigurations.Mode.Insert;
                else
                {
                    currentPromo.Mode = GlobalConfigurations.Mode.Update;
                    currentPromo.UniqueID = Guid.Parse(hdPromotionID.Value.Trim());
                }

                currentPromo.PromotionName = txtPromotionName.Text.Trim();
                currentPromo.AvailableUsage = currentPromo.MaxUsage = (txtMaxUsage.Text.Trim().Length != 0 ? int.Parse(txtMaxUsage.Text.Trim()) : 0);
                currentPromo.OrderTotalFrom = (txtPriceRangeFrom.Text.Trim().Length != 0 ? decimal.Parse(txtPriceRangeFrom.Text.Trim()) : 0);
                currentPromo.OrderTotalTo = (txtPriceRangeTo.Text.Trim().Length != 0 ? decimal.Parse(txtPriceRangeTo.Text.Trim()) : 0);
                currentPromo.UseFromPrice = chkUseFromPrice.Checked;
                currentPromo.StartDate = (txtStartDate.Text.Trim().Length != 0 ? DateTime.ParseExact(txtStartDate.Text.Trim(), "dd/MM/yyyy", null) : DateTime.MinValue);
                currentPromo.EndDate = (txtEndDate.Text.Trim().Length != 0 ? DateTime.ParseExact(txtEndDate.Text.Trim(), "dd/MM/yyyy", null) : DateTime.MinValue);
                currentPromo.IsActive = chkIsActive.Checked;
                currentPromo.UserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                currentPromo.PromotionDetailsList = promoOptions;

                if (PromotionBL.Save(currentPromo))
                {
                    WebUtilities.OpenNewAddEditDialog(this, "Success", "Promotion details has been saved successfully.<br>Do you want to add another Promotion?", this.ResolveClientUrl("~/Admin/Promotion/Promotions.aspx"));
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Admin/Promotion/Promotions.aspx", false);
        }

        private bool ValidatePageValue()
        {
            //if (ddlPromoType.SelectedValue.Equals("0"))
            //{
            //    WebUtilities.ShowValidationError(this, "validationMsgTop('#" + ddlPromoType.ClientID + "', 'Please select Salutation.');");
            //    return false;
            //}

            if (!ValidationUtility.ValidateString(txtPromotionName.Text.Trim()))
            {
                WebUtilities.ShowValidationError(this, "validationMsgTop('#" + txtPromotionName.ClientID + "', 'Please enter valid Promotion Name.');");
                return false;
            }

            //if (ValidationUtility.ValidateString(txtStartDate.Text.Trim()))
            //{
            if (!ValidationUtility.ValidateDate(txtStartDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowValidationError(this, "validationMsgTop('#" + txtStartDate.ClientID + "', 'Please select Valid Start Date.');");
                return false;
            }
            //}

            //if (ValidationUtility.ValidateString(txtEndDate.Text.Trim()))
            //{
            if (!ValidationUtility.ValidateDate(txtEndDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowValidationError(this, "validationMsgTop('#" + txtEndDate.ClientID + "', 'Please select Valid End Date.');");
                return false;
            }
            //}

            if (ValidationUtility.ValidateString(txtMaxUsage.Text.Trim()))
            {
                if (!ValidationUtility.ValidateInt(txtMaxUsage.Text.Trim()))
                {
                    WebUtilities.ShowValidationError(this, "validationMsgTop('#" + txtMaxUsage.ClientID + "', 'Please enter valid Max Number of Use.');");
                    return false;
                }
            }

            if (ValidationUtility.ValidateString(txtPriceRangeFrom.Text.Trim()))
            {
                if (!ValidationUtility.ValidateDecimal(txtPriceRangeFrom.Text.Trim()))
                {
                    WebUtilities.ShowValidationError(this, "validationMsgTop('#" + txtPriceRangeFrom.ClientID + "', 'Please enter valid Price Range From.');");
                    return false;
                }
            }

            if (ValidationUtility.ValidateString(txtPriceRangeTo.Text.Trim()))
            {
                if (!ValidationUtility.ValidateDecimal(txtPriceRangeTo.Text.Trim()))
                {
                    WebUtilities.ShowValidationError(this, "validationMsgTop('#" + txtPriceRangeTo.ClientID + "', 'Please enter valid Price Range To.');");
                    return false;
                }
            }

            return true;
        }

        protected void btnEditOptions_Click(object sender, EventArgs e)
        {
            LinkButton btnEditOptions = sender as LinkButton;
            GridViewRow cRow = (GridViewRow)btnEditOptions.Parent.Parent;
            HiddenField hdPromoDetailID = cRow.FindControl("hdPromoDetailID") as HiddenField;
            currPromoCode = promoOptions.Where(s => s.UniqueID == Guid.Parse(hdPromoDetailID.Value)).FirstOrDefault();
            if (currPromoCode != null)
            {
                hdPromotionDetailsID.Value = currPromoCode.UniqueID.ToString();

                currentProduct = ProductsBL.GetItem(currPromoCode.ProductsID, string.Empty);

                if (currentProduct != null)
                {
                    ddlCategory.SelectedIndex = ddlCategory.Items.IndexOf(ddlCategory.Items.FindByValue(currentProduct.ProductCategoryID.ToString()));
                    ddlBrand.SelectedIndex = ddlBrand.Items.IndexOf(ddlBrand.Items.FindByValue(currentProduct.ProductBrandID.ToString()));
                    ddlSize.SelectedIndex = ddlSize.Items.IndexOf(ddlSize.Items.FindByValue(currentProduct.ProductMeasurementID.ToString()));
                    FilterProduct((ddlCategory.SelectedValue != "0" ? Guid.Parse(ddlCategory.SelectedValue) : Guid.Empty), (ddlBrand.SelectedValue != "0" ? Guid.Parse(ddlBrand.SelectedValue) : Guid.Empty), (ddlSize.SelectedValue != "0" ? Guid.Parse(ddlSize.SelectedValue) : Guid.Empty));
                    ddlProduct.SelectedIndex = ddlProduct.Items.IndexOf(ddlProduct.Items.FindByValue(currentProduct.UniqueID.ToString()));
                    hdProductPrice.Value = currentProduct.UnitPrice.ToString("0.00");
                }

                ddlPromotionType.SelectedIndex = ddlPromotionType.Items.IndexOf(ddlPromotionType.Items.FindByValue(currPromoCode.PromoType.ToString()));
                //txtDiscountValue.Text = currPromoCode.Discount > 0 ? currPromoCode.Discount.ToString() : string.Empty;
                txtBuyQty.Text = currPromoCode.BuyingQty > 0 ? currPromoCode.BuyingQty.ToString() : string.Empty;
                txtFreeQty.Text = currPromoCode.DiscountQty > 0 ? currPromoCode.DiscountQty.ToString() : string.Empty;

                WebUtilities.RegisterStartupScript(this, "activeTab('#promoproducts'); ");
            }
        }

        protected void btnAdd_Click(object sender, EventArgs e)
        {
            if (ValidatePromotionDetails())
            {
                PromotionDetails promoDetails = new PromotionDetails();

                promoDetails.UniqueID = string.IsNullOrEmpty(hdPromotionDetailsID.Value) ? Guid.NewGuid() : Guid.Parse(hdPromotionDetailsID.Value);
                promoDetails.ProductsID = Guid.Parse(ddlProduct.SelectedValue);
                promoDetails.PromoType = ddlPromotionType.SelectedValue;
                promoDetails.DiscountType = ddlPromotionType.SelectedValue;
                //promoDetails.Discount = txtDiscountValue.Text.Trim().Length != 0 ? decimal.Parse(txtDiscountValue.Text.Trim()) : 0;
                promoDetails.BuyingQty = txtBuyQty.Text.Trim().Length != 0 ? int.Parse(txtBuyQty.Text.Trim()) : 0;
                promoDetails.DiscountQty = txtFreeQty.Text.Trim().Length != 0 ? int.Parse(txtFreeQty.Text.Trim()) : 0;

                promoDetails.IsActive = chkIsActive.Checked;
                promoDetails.UserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                promoOptions.RemoveAll(s => s.UniqueID == promoDetails.UniqueID);
                promoOptions.Add(promoDetails);
                BindPromotionDetails();

                FillListItems(false);
                ddlPromotionType.SelectedIndex = 0;
                /*txtDiscountValue.Text = */
                txtBuyQty.Text = txtFreeQty.Text = string.Empty;
                WebUtilities.RegisterStartupScript(this, "activeTab('#promoproducts');");
            }
        }

        private bool ValidatePromotionDetails()
        {
            if (ddlProduct.SelectedValue.Equals("0"))
            {
                WebUtilities.RegisterStartupScript(this, "validationMsgTop('#" + ddlProduct.ClientID + "', 'Please select valid Product.');activeTab('#promoproducts'); ");
                return false;
            }

            if (ddlPromotionType.SelectedValue.Equals("0"))
            {
                WebUtilities.RegisterStartupScript(this, "validationMsgTop('#" + ddlPromotionType.ClientID + "', 'Please select valid Promotion Type.');activeTab('#promoproducts'); ");
                return false;
            }

            if (ddlPromotionType.SelectedValue.Equals("Quantity"))
            {
                if (!ValidationUtility.ValidateInt(txtBuyQty.Text.Trim()))
                {
                    WebUtilities.RegisterStartupScript(this, "validationMsgTop('#" + txtBuyQty.ClientID + "', 'Please enter valid Buying Qty.');activeTab('#promoproducts'); "); //ShowHidePromoType();
                    return false;
                }

                if (!ValidationUtility.ValidateInt(txtFreeQty.Text.Trim()))
                {
                    WebUtilities.RegisterStartupScript(this, "validationMsgTop('#" + txtFreeQty.ClientID + "', 'Please enter valid Free Qty.');activeTab('#promoproducts'); ");//ShowHidePromoType();
                    return false;
                }
            }
            //else
            //{
            //    if (!ValidationUtility.ValidateDecimal(txtDiscountValue.Text.Trim()))
            //    {
            //        WebUtilities.RegisterStartupScript(this, "validationMsgTop('#" + txtDiscountValue.ClientID + "', 'Please enter valid Discount.');activeTab('#promoproducts');");//ShowHidePromoType();
            //        return false;
            //    }
            //}

            if (txtBuyQty.Text.Trim().Length != 0)
            {
                if (!ValidationUtility.ValidateInt(txtBuyQty.Text.Trim()))
                {
                    WebUtilities.RegisterStartupScript(this, "validationMsgTop('#" + txtBuyQty.ClientID + "', 'Please enter valid Buying Qty.');activeTab('#promoproducts'); "); //ShowHidePromoType();
                    return false;
                }
            }

            if (txtFreeQty.Text.Trim().Length != 0)
            {
                if (!ValidationUtility.ValidateInt(txtFreeQty.Text.Trim()))
                {
                    WebUtilities.RegisterStartupScript(this, "validationMsgTop('#" + txtFreeQty.ClientID + "', 'Please enter valid Free Qty.');activeTab('#promoproducts'); ");//ShowHidePromoType();
                    return false;
                }
            }

            //if (txtDiscountValue.Text.Trim().Length != 0)
            //{
            //    if (!ValidationUtility.ValidateDecimal(txtDiscountValue.Text.Trim()))
            //    {
            //        WebUtilities.RegisterStartupScript(this, "validationMsgTop('#" + txtDiscountValue.ClientID + "', 'Please enter valid Discount.');activeTab('#promoproducts');");//ShowHidePromoType();
            //        return false;
            //    }
            //}

            return true;
        }

        protected void btnDelete_Click(object sender, EventArgs e)
        {
            LinkButton btnDelete = sender as LinkButton;

            GridViewRow cRow = (GridViewRow)btnDelete.Parent.Parent;
            HiddenField productID = cRow.FindControl("hdPromoDetailID") as HiddenField;
            currPromoCode = PromotionDetailsBL.GetItem(Guid.Parse(productID.Value), Guid.Empty, Guid.Empty, string.Empty);
            currPromoCode.IsActive = false;
            if (PromotionDetailsBL.Save(currPromoCode))
            {
                WebUtilities.ShowMessage(this, "Promotion Product has been deleted successfully.", "Success");
                WebUtilities.RegisterStartupScript(this, "activeTab('#promoproducts');");
                promoOptions.RemoveAll(s => s.UniqueID == currPromoCode.UniqueID);
                BindPromotionDetails();
            }
        }

        protected void ddlCategory_SelectedIndexChanged(object sender, EventArgs e)
        {
            FilterProduct((ddlCategory.SelectedValue != "0" ? Guid.Parse(ddlCategory.SelectedValue) : Guid.Empty),
               (ddlBrand.SelectedValue != "0" ? Guid.Parse(ddlBrand.SelectedValue) : Guid.Empty),
                (ddlSize.SelectedValue != "0" ? Guid.Parse(ddlSize.SelectedValue) : Guid.Empty));
        }

        protected void ddlBrand_SelectedIndexChanged(object sender, EventArgs e)
        {
            FilterProduct((ddlCategory.SelectedValue != "0" ? Guid.Parse(ddlCategory.SelectedValue) : Guid.Empty),
              (ddlBrand.SelectedValue != "0" ? Guid.Parse(ddlBrand.SelectedValue) : Guid.Empty),
               (ddlSize.SelectedValue != "0" ? Guid.Parse(ddlSize.SelectedValue) : Guid.Empty));
        }

        protected void ddlSize_SelectedIndexChanged(object sender, EventArgs e)
        {
            FilterProduct((ddlCategory.SelectedValue != "0" ? Guid.Parse(ddlCategory.SelectedValue) : Guid.Empty),
              (ddlBrand.SelectedValue != "0" ? Guid.Parse(ddlBrand.SelectedValue) : Guid.Empty),
               (ddlSize.SelectedValue != "0" ? Guid.Parse(ddlSize.SelectedValue) : Guid.Empty));
        }

        protected void ddlProduct_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (ddlProduct.SelectedValue != "0")
            {
                currentProduct = productList.Where(x => x.UniqueID == Guid.Parse(ddlProduct.SelectedValue)).FirstOrDefault<Products>();
                if (currentProduct != null)
                {
                    hdProductPrice.Value = currentProduct.UnitPrice.ToString("0.00");
                }
            }
            WebUtilities.RegisterStartupScript(this, "activeTab('#promoproducts');");
        }

        private void FilterProduct(Guid categoryID, Guid brandID, Guid sizeID)
        {
            DataTable pTable;
            EnumerableRowCollection<DataRow> results = null;
            if (categoryID != Guid.Empty)
            {
                results = (from myRow in productTable.AsEnumerable()
                           where myRow.Field<Guid>("ProductCategoryID") == categoryID && myRow.Field<bool>("IsActive") == true
                           select myRow);
            }

            if (brandID != Guid.Empty)
            {
                results = (from myRow in results
                           where myRow.Field<Guid>("ProductBrandID") == brandID && myRow.Field<bool>("IsActive") == true
                           select myRow);
            }

            if (sizeID != Guid.Empty)
            {
                results = (from myRow in results
                           where myRow.Field<Guid>("ProductMeasurementID") == sizeID && myRow.Field<bool>("IsActive") == true
                           select myRow);
            }

            ddlProduct.Items.Clear();

            if (results.Count() > 0)
            {
                pTable = results.CopyToDataTable();
                ddlProduct.DataSource = pTable;
                ddlProduct.DataTextField = "ProductName";
                ddlProduct.DataValueField = "ProductsID";
                ddlProduct.DataBind();

                //WebUtilities.FillDropDownList(ddlProduct, pTable, "ProductsID", "ProductName");
            }
            else
            {
                pTable = null;
                ddlProduct.DataSource = pTable;
                ddlProduct.DataTextField = "ProductName";
                ddlProduct.DataValueField = "ProductsID";
                ddlProduct.DataBind();
                //WebUtilities.FillDropDownList(ddlProduct, pTable, "ProductsID", "ProductName");
            }
            WebUtilities.RegisterStartupScript(this, "activeTab('#promoproducts');");
        }

        private void BindPromotionDetails()
        {
            grdPromoDetails.DataSource = promoOptions;
            grdPromoDetails.DataBind();
        }

        protected void grdPromoDetails_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Label lblProductName = e.Row.FindControl("lblProductName") as Label;
                Label lblCategoryName = e.Row.FindControl("lblCategoryName") as Label;
                Label lblBrandName = e.Row.FindControl("lblBrandName") as Label;
                Label lblSizeName = e.Row.FindControl("lblSizeName") as Label;

                PromotionDetails cuPD = (PromotionDetails)e.Row.DataItem;

                currentProduct = ProductsBL.GetItem(cuPD.ProductsID, string.Empty);

                if (currentProduct != null)
                {
                    lblProductName.Text = currentProduct.ProductName;
                    lblCategoryName.Text = ProductCategoryBL.GetItem(currentProduct.ProductCategoryID, string.Empty).CategoryName;
                    lblBrandName.Text = ((currentProduct.ProductBrandID != null && currentProduct.ProductBrandID != Guid.Empty) ? ProductBrandBL.GetItem(currentProduct.ProductBrandID, string.Empty).BrandName : string.Empty);
                    lblSizeName.Text = ((currentProduct.ProductMeasurementID != null && currentProduct.ProductMeasurementID != Guid.Empty) ? ProductMeasurementBL.GetItem(currentProduct.ProductMeasurementID, string.Empty).MeasurementName : string.Empty);
                }
            }
        }
    }
}